/**  @file bta_focus_preproc.c
*
*    @brief This file implements the filter (see header)
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/


#include <bta_opencv_helper.h>
#include "bta_focus_preproc.h"
#include "bta_crop.h"
#include "bta_crop_chessboard.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifndef BTA_EXCLUDE_FILTERS

#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>


cv::Mat toPresentableMat(BTA_Channel *channel);

BTA_Status BFLTfocusPreprocInit(BTA_FltFocusPreprocConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst) {
    if (!handle || !config) {
        return BTA_StatusInvalidParameter;
    }
    *handle = 0;
    BTA_FltFocusPreprocInst *inst = (BTA_FltFocusPreprocInst *)calloc(1, sizeof(BTA_FltFocusPreprocInst));
    if (!inst) {
        return BTA_StatusOutOfMemory;
    }
    inst->channelToProcess = config->channelToProcess;
    inst->channelIdResult = config->channelIdResult;
    inst->infoEventInst = infoEventInst;

    //BTA_FltCropConfig cropConfig;
    //cropConfig.channelToProcess = config->channelToProcess;
    //cropConfig.roiStartX = 0.1f;
    //cropConfig.roiStartY = 0.1f;
    //cropConfig.roiEndX = 0.45f;
    //cropConfig.roiEndY = 0.45f;
    //cropConfig.channelIdResult = BTA_ChannelIdCustom1;
    //BFLTcropInit(&cropConfig, &inst->cropHandle1, infoEventInst);
    //cropConfig.roiStartX = 0.55f;
    //cropConfig.roiStartY = 0.1f;
    //cropConfig.roiEndX = 0.9f;
    //cropConfig.roiEndY = 0.45f;
    //BFLTcropInit(&cropConfig, &inst->cropHandle2, infoEventInst);
    //cropConfig.roiStartX = 0.1f;
    //cropConfig.roiStartY = 0.55f;
    //cropConfig.roiEndX = 0.45f;
    //cropConfig.roiEndY = 0.9f;
    //BFLTcropInit(&cropConfig, &inst->cropHandle3, infoEventInst);
    //cropConfig.roiStartX = 0.55f;
    //cropConfig.roiStartY = 0.55f;
    //cropConfig.roiEndX = 0.9f;
    //cropConfig.roiEndY = 0.9f;
    //BFLTcropInit(&cropConfig, &inst->cropHandle4, infoEventInst);

    //BTA_FltCropChessboardConfig cropChessboardConfig;
    //cropChessboardConfig.channelToProcess = BTA_ChannelIdCustom1;
    //cropChessboardConfig.scaleFactor = config->scaleFactorForChessboard;
    //cropChessboardConfig.edgeCountHor = config->edgeCountHorForChessboard;
    //cropChessboardConfig.edgeCountVert = config->edgeCountVertForChessboard;
    //cropChessboardConfig.border = -0.5f;
    //BFLTcropChessboardInit(&cropChessboardConfig, &inst->cropChessboardHandle, infoEventInst);

    *handle = inst;
    return BTA_StatusOk;
}


BTA_Status BFLTfocusPreprocClose(BTA_FltHandle *handle) {
    BTA_FltFocusPreprocInst **inst = (BTA_FltFocusPreprocInst **)handle;
    free(*inst);
    *inst = 0;
    return BTA_StatusOk;
}


BTA_Status BFLTfocusPreprocApply(BTA_FltHandle handle, BTA_Frame **frame) {
    BTA_FltFocusPreprocInst *inst = (BTA_FltFocusPreprocInst *)handle;
    int chInd;
    int chCount = (*frame)->channelsLen;
    for (chInd = 0; chInd < chCount; chInd++) {
        BTA_Channel *channel = ((*frame)->channels)[chInd];
        if (channel->id == inst->channelToProcess) {

            cv::Mat matTemp = BTAtoMat(channel);

            switch (channel->dataFormat) {
                case BTA_DataFormatFloat32:
                    break;
                case BTA_DataFormatUInt16: {
                    break;
                }
            default:
                BTAinfoEventHelper(inst->infoEventInst, 3, BTA_StatusNotSupported, "BFLTdctApply: unsupported data format", channel->dataFormat);
                return BTA_StatusNotSupported;
            }


            int x, y;
            cv::Mat pattern;
            pattern.create(2 * std::min(8, channel->yRes / 2), 2 * std::min(8, channel->xRes / 2), CV_8U);  // make size always even
            for (y = 0; y < pattern.size().height; y++) {
                for (x = 0; x < pattern.size().width; x++) {
                    if ((x < pattern.size().width / 2) ^ (y < pattern.size().height / 2)) {
                        pattern.at<uint8_t>(y, x) = 255;
                    }
                    else {
                        pattern.at<uint8_t>(y, x) = 0;
                    }
                }
            }

            cv::Mat pattern2;
            cv::flip(pattern, pattern2, 1);

            int xResResultMatchTemplate = channel->xRes - pattern.cols + 1;
            int yResResultMatchTemplate = channel->yRes - pattern.rows + 1;
            cv::Mat resultMatchTemplate;
            double minBestMatch1, minBestMatch2, maxDummy;
            cv::Point pointBestMatch1, pointBestMatch2, pointDummy;

            float *dataResult = (float *)malloc(4 * sizeof(float));
            int i;
            int xRes = channel->xRes;
            int yRes = channel->yRes;
            int xRes03 = 3 * xRes / 10;		// 48
            int xRes015 = 3 * xRes / 20;	// 24
            int yRes03 = 3 * yRes / 10;		// 36
            int yRes015 = 3 * yRes / 20;	// 18
            cv::Rect r0 = cv::Rect(xRes03 - xRes015, yRes03 - yRes015, 2 * xRes015, 2 * yRes015);
            cv::Rect r1 = cv::Rect(xRes - xRes03 - xRes015, yRes03 - yRes015, 2 * xRes015, 2 * yRes015);
            cv::Rect r2 = cv::Rect(xRes03 - xRes015, yRes - yRes03 - yRes015, 2 * xRes015, 2 * yRes015);
            cv::Rect r3 = cv::Rect(xRes - xRes03 - xRes015, yRes - yRes03 - yRes015, 2 * xRes015, 2 * yRes015);
            cv::Rect r[] = { r0, r1, r2, r3 };

            for (i = 0; i < 1; i++) {
                cv::Mat inCropped = matTemp(r[i]);
                double minOrig, maxOrig;
                cv::minMaxLoc(inCropped, &minOrig, &maxOrig);
                cv::Mat inContrast;
                if (std::abs(minOrig) >= 1 && (maxOrig - minOrig != 0)) {
                    inCropped.convertTo(inContrast, CV_8U, 255.0 / (maxOrig - minOrig), -255.0 / minOrig);
                }
                else {
                    inCropped.convertTo(inContrast, CV_8U, 255.0 / maxOrig);
                }

                resultMatchTemplate.create(yResResultMatchTemplate, xResResultMatchTemplate, CV_32FC1);
                cv::matchTemplate(inContrast, pattern, resultMatchTemplate, CV_TM_SQDIFF_NORMED);
				//cv::normalize(resultMatchTemplate, resultMatchTemplate, 0, 1, cv::NORM_MINMAX, -1, cv::Mat());
                minMaxLoc(resultMatchTemplate, &minBestMatch1, &maxDummy, &pointBestMatch1, &pointDummy, cv::Mat());

                resultMatchTemplate.create(yResResultMatchTemplate, xResResultMatchTemplate, CV_32FC1);
                cv::matchTemplate(inContrast, pattern2, resultMatchTemplate, CV_TM_SQDIFF_NORMED);
                minMaxLoc(resultMatchTemplate, &minBestMatch2, &maxDummy, &pointBestMatch2, &pointDummy, cv::Mat());

				//if (minBestMatch1 > 0.3 && minBestMatch2 > 0.3) {
				//	cv::Mat tempMat = cv::Mat::zeros(pattern.size(), inContrast.type());
				//	BTAinsertChannelIntoFrame(frameTemp, toChannel((BTA_ChannelId)(BTA_ChannelIdCustom1 + (i * 0x1000)), BTA_UnitUnitLess, tempMat));
				//	BTAinsertChannelIntoFrame(frameTemp, toChannel((BTA_ChannelId)(BTA_ChannelIdCustom1 + (i * 0x1000)), BTA_UnitUnitLess, tempMat));
				//	dataResult[i] = 0.0f;
				//	continue;
				//}

				cv::Mat patch;
                if (minBestMatch1 < minBestMatch2) {
                    patch = inContrast(cv::Rect(pointBestMatch1.x, pointBestMatch1.y, pattern.size().width, pattern.size().height));
                }
                else {
                    patch = inContrast(cv::Rect(pointBestMatch2.x, pointBestMatch2.y, pattern.size().width, pattern.size().height));
                }

                cv::Mat patchDerived;
                cv::Laplacian(patch, patchDerived, CV_16S);
                for (y = 0; y < patchDerived.size().height; y++) {
                    for (x = 0; x < patchDerived.size().width; x++) {
                        patchDerived.at<int16_t>(y, x) = abs(patchDerived.at<int16_t>(y, x));
                    }
                }

                cv::Mat patchBlurred;
                cv::GaussianBlur(patchDerived, patchBlurred, cv::Size(3, 3), 1.5);

                // debug
                //patch.at<int16_t>(0, 0) = pointBestMatch.x;
                //patch.at<int16_t>(0, 1) = pointBestMatch.y;
                //BTAinsertChannelIntoFrame((*frame), BTAtoChannel(BTA_ChannelIdCustom1, BTA_UnitUnitLess, inContrast));
				//BTAinsertChannelIntoFrame(frameTemp, toChannel((BTA_ChannelId)(BTA_ChannelIdCustom1 + (i * 0x1000)), BTA_UnitUnitLess, patch));
                //BTAinsertChannelIntoFrame(frameTemp, toChannel((BTA_ChannelId)(BTA_ChannelIdCustom1 + (i * 0x1000)), BTA_UnitUnitLess, patchDerived));
                //BTAinsertChannelIntoFrame(frameTemp, toChannel((BTA_ChannelId)(BTA_ChannelIdCustom1 + (i * 0x1000)), BTA_UnitUnitLess, pattern));


				if (minBestMatch1 > 0.3 && minBestMatch2 > 0.3) {
					dataResult[i] = 0.0f;
				}
				else {
					double minDerivation, maxDerivation;
					minMaxLoc(patchBlurred, &minDerivation, &maxDerivation);
					dataResult[i] = (float)maxDerivation;
				}
            }
            if (inst->channelIdResult) {
                BTAinsertChannelDataIntoFrame((*frame), inst->channelIdResult, 2, 2, BTA_DataFormatFloat32, BTA_UnitUnitLess, 0, 0, (uint8_t *)dataResult, 4 * sizeof(float));
            }
            else {
                free(channel->data);
                channel->data = (uint8_t *)dataResult;
                channel->xRes = 2;
                channel->yRes = 2;
                channel->dataLen = 4 * sizeof(float);
            }
            return BTA_StatusOk;
        }
    }
    return BTA_StatusOk;
}
#endif